/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import com.samsthenerd.duckyperiphs.hexcasting.ConjuredDuckyBER;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCasting;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortBlock;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortBlockEntity;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5251;
import net.minecraft.class_6344;

@Environment(value=EnvType.CLIENT)
public class DuckyCastingClient {
    public static void init() {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)DuckyCasting.CONJURED_DUCKY_BLOCK_ENTITY.get()), ConjuredDuckyBER::new);
        if (Platform.isFabric()) {
            DuckyCastingClient.registerEntityRenderers();
        }
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)DuckyCasting.FOCAL_PORT_BLOCK.get(), (class_2248)DuckyCasting.CONJURED_DUCKY_BLOCK.get()});
        DuckyCastingClient.setupColorProviders();
        DuckyCastingClient.setupScryingDisplayers();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(DuckyCasting.FOCAL_PORT_WRAPPER_ENTITY, class_6344::new);
    }

    private static void setupColorProviders() {
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            int thisColor = FocalPortBlock.getColor(world, pos);
            return thisColor;
        }, (class_2248[])new class_2248[]{(class_2248)DuckyCasting.FOCAL_PORT_BLOCK.get()});
    }

    private static void setupScryingDisplayers() {
        ScryingLensOverlayRegistry.addDisplayer((class_2248)((class_2248)DuckyCasting.FOCAL_PORT_BLOCK.get()), (lines, state, pos, observer, world, direction) -> {
            class_2586 patt2223$temp = world.method_8321(pos);
            if (patt2223$temp instanceof FocalPortBlockEntity) {
                FocalPortBlockEntity fpbe = (FocalPortBlockEntity)patt2223$temp;
                if (!fpbe.hasFocus()) {
                    lines.add(new Pair((Object)class_1799.field_8037, (Object)class_2561.method_43470((String)"No Focus")));
                } else {
                    class_1799 focusStack = fpbe.method_5438(0);
                    class_2487 tag = HexItems.FOCUS.readIotaTag(focusStack);
                    if (tag != null) {
                        lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8162), (Object)IotaType.getDisplay((class_2487)tag)));
                    }
                    lines.add(new Pair((Object)focusStack, (Object)focusStack.method_7964().method_27661().method_27694(style -> style.method_27703(class_5251.method_27717((int)fpbe.getColor())))));
                }
            }
        });
    }
}

